#pragma string name DStar
#pragma output nostreams

void MovePiece(char *ptr, char plusx, char plusy);
char TestNextPosIsStop(char nextpos);
char CheckNotFinished(void);
void SetupLevel(void);
void DrawBoard(void);
void Gamekeys(void);

char BallOffset;        /* Ball position */
char BoxOffset;         /* Box position */
char PieceIsBall;       /* 1 = box, 0 = ball */
char Level;             /* Guess! */
char Board[144];        /* Space for decompressed Level */

#define MAXLEVEL 25     /* Highest Level   */
#define STARTLEV  1     /* Start Level */
#define TRUE      1
#define FALSE     0

/* Block numbers.. */
#define WALL 1
#define BUBB 2
#define BALL 3
#define BOX  4


#define K_NEXTLEV '+'
#define K_PREVLEV '-'


#if defined __TI82__ || defined __TI83__ || defined __TI8X__ || defined __TI85__ || defined __TI86__
#define K_UP      11  /* arrow up     */
#define K_DOWN    10  /* arrow down   */
#define K_LEFT     8  /* arrow left   */
#define K_RIGHT    9  /* arrow right  */
#define K_SWITCH  13  /* [Enter]      */
#define K_EXIT    '7' /* [Esc]/[Quit] */
#define K_CLEAR   '9'
#endif

#ifndef K_UP
#define K_UP       'Q'  /* arrow up     */
#define K_DOWN     'A' /* arrow down   */
#define K_LEFT     'O'  /* arrow left   */
#define K_RIGHT    'P'  /* arrow right  */
#define K_SWITCH   ' '  /* [SPACE]      */
#define K_EXIT     'G' /* [Esc]/[Quit] */
#define K_CLEAR    'H'
#endif


#if (spritesize == 4)
char sprites[]={
       4,4,
       0x00,	// empty sprite
       0x00,
       0x00,
       0x00,
 
       4,4,
       0xE0,	//1=edge,
       0xE0,
       0xE0,
       0x00,
 
       4,4,
       0x40,	//2=bubble
       0xA0,
       0x40,
       0x00,
 
       4,4,
       0x40,	//3=moveable ball
       0xE0,
       0x40,
       0x00,

       4,4,
       0xE0,	//4=moveable block
       0xA0,
       0xE0,
       0x00
};
#endif

#if (spritesize == 5)
char sprites[]={
		5,5,
       0x00,	// empty sprite
       0x00,
       0x00,
       0x00,
       0x00,

       5,5,
       0xF0,	//1=edge,
       0xB0,
       0xD0,
       0xF0,
       0x00,

       5,5,
       0x60,	//2=bubble
       0x90,
       0x90,
       0x60,
       0x00,

       5,5,
       0x60,	//3=moveable ball
       0xD0,
       0xF0,
       0x60,
       0x00,

       5,5,
       0xF0,	//4=moveable block
       0x90,
       0x90,
       0xF0,
       0x00
};
#endif

#if (spritesize == 6)
char sprites[]={
       6,6,
       0x00, // empty sprite
       0x00,
       0x00,
       0x00,
       0x00,
       0x00,

       6,6,
       0x78,	//1=edge,
       0x84,
       0x84,
       0x84,
       0x84,
       0x78,

       6,6,
       0x00,	//2=bubble
       0x30,
       0x48,
       0x48,
       0x30,
       0x00,

       6,6,
       0x00,	//3=moveable ball
       0x30,
       0x68,
       0x78,
       0x30,
       0x00,

       6,6,
       0x00,	//4=moveable block
       0x78,
       0x48,
       0x48,
       0x78,
       0x00
};
#endif


#if (spritesize == 7)
char sprites[]={
  	7,7,	//0=blank
       0x00,
       0x00,
       0x00,
       0x00,
       0x00,
       0x00,
       0x00,

  	8,7,	//1=edge, this sprite is 1 pixel larger  ;)
       0x7E,
       0xA9,
       0xC7,
       0xB1,
       0xCB,
       0xA5,
       0x7E,

  	7,7,	//2=clear ball
       0x00,
       0x18,
       0x24,
       0x24,
       0x18,
       0x00,
       0x00,

  	7,7,	//3=moveable ball
       0x00,
       0x18,
       0x34,
       0x3C,
       0x18,
       0x00,
       0x00,

  	7,7,	//4=moveable block
       0x00,
       0x3C,
       0x3C,
       0x3C,
       0x3C,
       0x00,
       0x00
};
#endif

#if (spritesize == 8)
char sprites[]={
       8,8,
       0x00,	// empty sprite
       0x00,
       0x00,
       0x00,
       0x00,
       0x00,
       0x00,
       0x00,

       8,8,
       0x7E,	//1=edge,
       0xA9,
       0xC7,
       0xB1,
       0xCB,
       0xA5,
       0xA9,
       0x7E,

       8,8,
       0x00,	//2=bubble
       0x00,
       0x18,
       0x24,
       0x24,
       0x18,
       0x00,
       0x00,

       8,8,
       0x00,	//3=moveable ball
       0x3C,
       0x76,
       0x7A,
       0x7A,
       0x7E,
       0x3C,
       0x00,

       8,8,
       0x00,	//4=moveable block
       0x7E,
       0x42,
       0x42,
       0x42,
       0x42,
       0x7E,
       0x00
};
#endif


#if (spritesize == 10)
char sprites[] = {
 10, 10, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00  ,
 10, 10, 0x7F , 0x80 , 0xAA , 0x40 , 0xD0 , 0x40 , 0xA0 , 0x40 , 0xC0 , 0x40 , 0x80 
, 0xC0 , 0x81 , 0x40 , 0x82 , 0xC0 , 0x95 , 0x40 , 0x7F , 0x80  ,
 10, 10, 0x00 , 0x00 , 0x00 , 0x00 , 0x1E , 0x00 , 0x21 , 0x00 , 0x21 , 0x00 , 0x21 
, 0x00 , 0x21 , 0x00 , 0x1E , 0x00 , 0x00 , 0x00 , 0x00 , 0x00  ,
 10, 10, 0x00 , 0x00 , 0x1E , 0x00 , 0x3F , 0x00 , 0x7B , 0x80 , 0x7D , 0x80 , 0x7F 
, 0x80 , 0x7F , 0x80 , 0x3F , 0x00 , 0x1E , 0x00 , 0x00 , 0x00  ,
 10, 10, 0x00 , 0x00 , 0x7F , 0x80 , 0x5E , 0x80 , 0x61 , 0x80 , 0x61 , 0x80 , 0x61 
, 0x80 , 0x61 , 0x80 , 0x5E , 0x80 , 0x7F , 0x80 , 0x00 , 0x00  };
#endif


#if ((spritesize == 15)|(spritesize == 16))
char sprites[]={       16,16,
     0,0,0,0,0,0,0,0,	// empty sprite
     0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,
 
       16,16,
       0x7F, 0xFE,	//1=edge,
       0xAA, 0xA9,
       0xD5, 0x41,
       0xA8, 0x01,
       0xD0, 0x01,
       0xA0, 0x01,
       0xC0, 0x01,
       0x80, 0x01,
       0x80, 0x01,
       0x80, 0x01,
       0x80, 0x01,
       0x80, 0x01,
       0x80, 0x01,
       0x80, 0x01,
       0x80, 0x01,
       0x7F, 0xFE,

       16,16,
       0x00, 0x00,	//2=bubble,
       0x00, 0x00,
       0x00, 0x00,
       0x00, 0x00,
       0x03, 0xC0,
       0x04, 0x20,
       0x08, 0x90,
       0x08, 0x50,
       0x08, 0x10,
       0x08, 0x10,
       0x04, 0x20,
       0x03, 0xC0,
       0x00, 0x00,
       0x00, 0x00,
       0x00, 0x00,
       0x00, 0x00,

       16,16,
       0x00, 0x00,	//3=moveable ball
       0x00, 0x00,
       0x03, 0xC0,
       0x0F, 0x30,
       0x1F, 0xD8,
       0x1F, 0xE8,
       0x3F, 0xEC,
       0x3F, 0xFC,
       0x3F, 0xFC,
       0x3F, 0xFC,
       0x1F, 0xF8,
       0x1F, 0xF8,
       0x0F, 0xF0,
       0x03, 0xC0,
       0x00, 0x00,
       0x00, 0x00,

       16,16,
       0x00, 0x00,	//4=moveable block
       0x7F, 0xFE,
       0x4D, 0xB2,
       0x5F, 0xFA,
       0x70, 0x0E,
       0x70, 0x0E,
       0x50, 0x0A,
       0x70, 0x0E,
       0x70, 0x0E,
       0x50, 0x0A,
       0x70, 0x0E,
       0x70, 0x0E,
       0x5F, 0xFA,
       0x4D, 0xB2,
       0x7F, 0xFE,
       0x00, 0x00
};
#endif

#if (spritesize == 14)
char sprites[] = {
14, 14, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00,
14, 14, 0x7F , 0xF8 , 0xD5 , 0x44 , 0xAA , 0x04 , 0xD0 , 0x04 , 0xA0 , 0x04 , 0xC0 
, 0x04 , 0x80 , 0x04 , 0x80 , 0x0C , 0x80 , 0x04 , 0x80 , 0x0C , 0x80 , 0x14 
, 0x80 , 0xAC , 0x85 , 0x54 , 0x7F , 0xF8,
14, 14, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x07 , 0x80 , 0x08 , 0x40 , 0x11 
, 0x20 , 0x10 , 0xA0 , 0x10 , 0x20 , 0x10 , 0x20 , 0x08 , 0x40 , 0x07 , 0x80 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00,
14, 14, 0x00 , 0x00 , 0x07 , 0x80 , 0x1F , 0xE0 , 0x3F , 0xF0 , 0x3F , 0x70 , 0x7F 
, 0xB8 , 0x7F , 0xB8 , 0x7F , 0xF8 , 0x7F , 0xF8 , 0x3F , 0xF0 , 0x3F , 0xF0 
, 0x1F , 0xE0 , 0x07 , 0x80 , 0x00 , 0x00,
14, 14, 0x00 , 0x00 , 0x7F , 0xF8 , 0x55 , 0x58 , 0x6A , 0xA8 , 0x50 , 0x18 , 0x60 
, 0x28 , 0x50 , 0x18 , 0x60 , 0x28 , 0x50 , 0x18 , 0x60 , 0x28 , 0x55 , 0x58 
, 0x6A , 0xA8 , 0x7F , 0xF8 , 0x00 , 0x00  };
#endif



#if (spritemem == 102)
char sprites[] = {
40, 20, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 ,
40, 20, 0x0F , 0xFF , 0xFF , 0xFF , 0xF8 , 0x3D , 0x55 , 0x54 , 0x00 , 0x0C , 0x6A 
, 0xAA , 0x80 , 0x00 , 0x06 , 0x75 , 0x44 , 0x00 , 0x00 , 0x06 , 0xEA , 0x80 
, 0x00 , 0x00 , 0x03 , 0xD4 , 0x00 , 0x00 , 0x00 , 0x03 , 0xA0 , 0x00 , 0x00 
, 0x00 , 0x03 , 0xC0 , 0x00 , 0x00 , 0x00 , 0x03 , 0xA0 , 0x00 , 0x00 , 0x00 
, 0x03 , 0xC0 , 0x00 , 0x00 , 0x00 , 0x03 , 0x80 , 0x00 , 0x00 , 0x00 , 0x03 
, 0xC0 , 0x00 , 0x00 , 0x00 , 0x07 , 0x80 , 0x00 , 0x00 , 0x00 , 0x03 , 0x80 
, 0x00 , 0x00 , 0x00 , 0x07 , 0x80 , 0x00 , 0x00 , 0x00 , 0x0B , 0xC0 , 0x00 
, 0x00 , 0x00 , 0x17 , 0x60 , 0x00 , 0x00 , 0x08 , 0xAE , 0x60 , 0x00 , 0x00 
, 0x15 , 0x56 , 0x38 , 0x00 , 0x0A , 0xAA , 0xAC , 0x0F , 0xFF , 0xFF , 0xFF 
, 0xF8 ,
40, 20, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x01 , 0xFF , 0x80 , 0x00 , 0x00 , 0x06 
, 0x00 , 0x60 , 0x00 , 0x00 , 0x08 , 0x00 , 0x10 , 0x00 , 0x00 , 0x10 , 0x07 
, 0x08 , 0x00 , 0x00 , 0x30 , 0x01 , 0x0C , 0x00 , 0x00 , 0x20 , 0x00 , 0x84 
, 0x00 , 0x00 , 0x20 , 0x00 , 0x84 , 0x00 , 0x00 , 0x20 , 0x00 , 0x04 , 0x00 
, 0x00 , 0x20 , 0x00 , 0x04 , 0x00 , 0x00 , 0x30 , 0x00 , 0x0C , 0x00 , 0x00 
, 0x10 , 0x00 , 0x08 , 0x00 , 0x00 , 0x08 , 0x00 , 0x10 , 0x00 , 0x00 , 0x06 
, 0x00 , 0x60 , 0x00 , 0x00 , 0x01 , 0xFF , 0x80 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 ,
40, 20, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x03 , 0xFF , 0xE0 , 0x00 , 0x00 
, 0x1F , 0xFF , 0xFC , 0x00 , 0x00 , 0x7F , 0xFF , 0xFF , 0x00 , 0x00 , 0xFF 
, 0xFF , 0x9F , 0x80 , 0x01 , 0xFF , 0xFF , 0xE7 , 0xC0 , 0x01 , 0xFF , 0xFF 
, 0xF7 , 0xC0 , 0x03 , 0xFF , 0xFF , 0xF3 , 0xE0 , 0x03 , 0xFF , 0xFF , 0xF3 
, 0xE0 , 0x03 , 0xFF , 0xFF , 0xFB , 0xE0 , 0x03 , 0xFF , 0xFF , 0xFB , 0xE0 
, 0x03 , 0xFF , 0xFF , 0xFF , 0xE0 , 0x03 , 0xFF , 0xFF , 0xFF , 0xE0 , 0x01 
, 0xFF , 0xFF , 0xFF , 0xC0 , 0x01 , 0xFF , 0xFF , 0xFF , 0xC0 , 0x00 , 0xFF 
, 0xFF , 0xFF , 0x80 , 0x00 , 0x7F , 0xFF , 0xFF , 0x00 , 0x00 , 0x1F , 0xFF 
, 0xFC , 0x00 , 0x00 , 0x03 , 0xFF , 0xE0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 ,
40, 20, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x3F , 0xFF , 0xFF , 0xFF , 0xFC , 0x35 
, 0x55 , 0x55 , 0x55 , 0x54 , 0x2A , 0xAA , 0xAA , 0xAA , 0xAC , 0x35 , 0x55 
, 0x55 , 0x55 , 0x54 , 0x2A , 0x00 , 0x00 , 0x00 , 0x2C , 0x34 , 0x00 , 0x00 
, 0x00 , 0x54 , 0x2A , 0x00 , 0x00 , 0x00 , 0x2C , 0x34 , 0x00 , 0x00 , 0x00 
, 0x54 , 0x2A , 0x00 , 0x00 , 0x00 , 0x2C , 0x34 , 0x00 , 0x00 , 0x00 , 0x54 
, 0x2A , 0x00 , 0x00 , 0x00 , 0x2C , 0x34 , 0x00 , 0x00 , 0x00 , 0x54 , 0x2A 
, 0x00 , 0x00 , 0x00 , 0x2C , 0x34 , 0x00 , 0x00 , 0x00 , 0x54 , 0x2A , 0xAA 
, 0xAA , 0xAA , 0xAC , 0x35 , 0x55 , 0x55 , 0x55 , 0x54 , 0x2A , 0xAA , 0xAA 
, 0xAA , 0xAC , 0x3F , 0xFF , 0xFF , 0xFF , 0xFC , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00  };
#else
#if (spritesize == 20)
char sprites[] = {
20, 20, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00,
20, 20, 0x3F , 0xFF , 0xC0 , 0x55 , 0x50 , 0x20 , 0xAA , 0x00 , 0x10 , 0xD0 , 0x00 
, 0x10 , 0xA0 , 0x00 , 0x10 , 0xC0 , 0x00 , 0x10 , 0x80 , 0x00 , 0x10 , 0xC0 
, 0x00 , 0x10 , 0x80 , 0x00 , 0x10 , 0x80 , 0x00 , 0x10 , 0x80 , 0x00 , 0x10 
, 0x80 , 0x00 , 0x10 , 0x80 , 0x00 , 0x30 , 0x80 , 0x00 , 0x10 , 0x80 , 0x00 
, 0x30 , 0x80 , 0x00 , 0x50 , 0x80 , 0x00 , 0xB0 , 0x80 , 0x05 , 0x50 , 0x40 
, 0x2A , 0xA0 , 0x3F , 0xFF , 0xC0,
20, 20, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0xF0 , 0x00 , 0x03 , 0x0C , 0x00 , 0x04 , 0x02 , 0x00 , 0x04 
, 0x12 , 0x00 , 0x08 , 0x09 , 0x00 , 0x08 , 0x09 , 0x00 , 0x08 , 0x01 , 0x00 
, 0x08 , 0x01 , 0x00 , 0x04 , 0x02 , 0x00 , 0x04 , 0x02 , 0x00 , 0x03 , 0x0C 
, 0x00 , 0x00 , 0xF0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00,
20, 20, 0x00 , 0x00 , 0x0F , 0x00 , 0x00 , 0x0F , 0x01 , 0xF8 , 0x0E , 0x07 , 0xFE 
, 0x0F , 0x0F , 0xFF , 0x0F , 0x1F , 0xEF , 0x8F , 0x1F , 0xF7 , 0x8F , 0x3F 
, 0xF3 , 0xC0 , 0x3F , 0xFB , 0xC0 , 0x3F , 0xFF , 0xC0 , 0x3F , 0xFF , 0xC0 
, 0x3F , 0xFF , 0xC0 , 0x3F , 0xFF , 0xC0 , 0x1F , 0xFF , 0x80 , 0x1F , 0xFF 
, 0x80 , 0x0F , 0xFF , 0x00 , 0x07 , 0xFE , 0x00 , 0x01 , 0xF8 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00,
20, 20, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x3F , 0xFF , 0xC0 , 0x2A , 0xAA 
, 0xC0 , 0x35 , 0x55 , 0x40 , 0x29 , 0xF8 , 0xC0 , 0x30 , 0x01 , 0x40 , 0x2C 
, 0x02 , 0xC0 , 0x34 , 0x03 , 0x40 , 0x2C , 0x02 , 0xC0 , 0x34 , 0x03 , 0x40 
, 0x2C , 0x02 , 0xC0 , 0x34 , 0x03 , 0x40 , 0x28 , 0x00 , 0xC0 , 0x31 , 0xF9 
, 0x40 , 0x2A , 0xAA , 0xC0 , 0x35 , 0x55 , 0x40 , 0x3F , 0xFF , 0xC0 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00  };
#endif
#endif

#if (spritesize == 21)
char sprites[] = {
 32, 22, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 32, 22, 0x3F , 0xFF , 0xFF , 0xFC , 0x55 , 0x55 , 0x40 , 0x02 , 0xAA , 0xAA , 0x00 
, 0x01 , 0xD5 , 0x50 , 0x00 , 0x01 , 0xAA , 0x80 , 0x00 , 0x01 , 0xD4 , 0x00 
, 0x00 , 0x01 , 0xA8 , 0x00 , 0x00 , 0x01 , 0xD4 , 0x00 , 0x00 , 0x01 , 0xA8 
, 0x00 , 0x00 , 0x01 , 0xD0 , 0x00 , 0x00 , 0x01 , 0xA0 , 0x00 , 0x00 , 0x03 
, 0xD0 , 0x00 , 0x00 , 0x01 , 0xA0 , 0x00 , 0x00 , 0x03 , 0xC0 , 0x00 , 0x00 
, 0x01 , 0xA0 , 0x00 , 0x00 , 0x03 , 0xC0 , 0x00 , 0x00 , 0x05 , 0x80 , 0x00 
, 0x00 , 0x03 , 0xC0 , 0x00 , 0x00 , 0x05 , 0x80 , 0x00 , 0x00 , 0x0B , 0x80 
, 0x00 , 0x00 , 0x15 , 0x40 , 0x00 , 0x00 , 0xAA , 0x3F , 0xFF , 0xFF , 0xFC 
, 32, 22, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x07 , 0xE0 , 0x00 , 0x00 , 0x18 
, 0x18 , 0x00 , 0x00 , 0x20 , 0x04 , 0x00 , 0x00 , 0x40 , 0x62 , 0x00 , 0x00 
, 0x80 , 0x11 , 0x00 , 0x00 , 0x80 , 0x11 , 0x00 , 0x00 , 0x80 , 0x01 , 0x00 
, 0x00 , 0x80 , 0x01 , 0x00 , 0x00 , 0x40 , 0x02 , 0x00 , 0x00 , 0x20 , 0x04 
, 0x00 , 0x00 , 0x18 , 0x18 , 0x00 , 0x00 , 0x07 , 0xE0 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 32, 22, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x0F , 0xF0 , 0x00 , 0x00 , 0x3F , 0xFC , 0x00 , 0x00 , 0xFF 
, 0xDF , 0x00 , 0x01 , 0xFF , 0xE7 , 0x80 , 0x03 , 0xFF , 0xF3 , 0xC0 , 0x03 
, 0xFF , 0xF9 , 0xC0 , 0x07 , 0xFF , 0xF9 , 0xE0 , 0x07 , 0xFF , 0xF9 , 0xE0 
, 0x07 , 0xFF , 0xFD , 0xE0 , 0x07 , 0xFF , 0xFF , 0xE0 , 0x03 , 0xFF , 0xFF 
, 0xC0 , 0x03 , 0xFF , 0xFF , 0xC0 , 0x01 , 0xFF , 0xFF , 0x80 , 0x00 , 0xFF 
, 0xFF , 0x00 , 0x00 , 0x3F , 0xFC , 0x00 , 0x00 , 0x0F , 0xF0 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 32, 22, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x3F , 0xFF , 0xFF 
, 0xFC , 0x35 , 0x55 , 0x55 , 0x5C , 0x3A , 0xAA , 0xAA , 0xAC , 0x34 , 0x00 
, 0x00 , 0x5C , 0x3A , 0x00 , 0x00 , 0x2C , 0x34 , 0x00 , 0x00 , 0x5C , 0x3A 
, 0x00 , 0x00 , 0x2C , 0x34 , 0x00 , 0x00 , 0x5C , 0x3A , 0x00 , 0x00 , 0x2C 
, 0x34 , 0x00 , 0x00 , 0x5C , 0x3A , 0x00 , 0x00 , 0x2C , 0x34 , 0x00 , 0x00 
, 0x5C , 0x3A , 0x00 , 0x00 , 0x2C , 0x34 , 0x00 , 0x00 , 0x5C , 0x3A , 0x00 
, 0x00 , 0x2C , 0x35 , 0x55 , 0x55 , 0x5C , 0x3A , 0xAA , 0xAA , 0xAC , 0x3F 
, 0xFF , 0xFF , 0xFC , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
 };

#endif


#if (spritesize == 28)
char sprites[] = { 
64, 28, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00
, 64, 28, 0x0F , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xF0 , 0x35 , 0x55 , 0x55 
, 0x55 , 0x50 , 0x00 , 0x00 , 0x1C , 0x6A , 0xAA , 0xAA , 0xA8 , 0x00 , 0x00 
, 0x00 , 0x06 , 0xD5 , 0x55 , 0x55 , 0x00 , 0x00 , 0x00 , 0x00 , 0x03 , 0xEA 
, 0xAA , 0x80 , 0x00 , 0x00 , 0x00 , 0x00 , 0x03 , 0xD5 , 0x50 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x03 , 0xEA , 0xA8 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x03 , 0xD5 , 0x40 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x03 , 0xEA , 0xA0 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x03 , 0xD5 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x03 , 0xEA , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x03 
, 0xD5 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x07 , 0xEA , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x0B , 0xD4 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x07 , 0xE8 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x0B , 0xD4 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x07 , 0xE0 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x0B , 0xD0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x17 , 0xE8 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x2B , 0xC0 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x17 , 0xC0 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x2B , 0xC0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x01 , 0x57 
, 0xC0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x02 , 0xAB , 0xC0 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x01 , 0x55 , 0x57 , 0x40 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0xAA , 0xAA , 0x60 , 0x00 , 0x00 , 0x00 , 0x00 , 0x15 , 0x55 , 0x56 , 0x38 
, 0x00 , 0x00 , 0x00 , 0x00 , 0xAA , 0xAA , 0xBC , 0x0F , 0xFF , 0xFF , 0xFF 
, 0xFF , 0xFF , 0xFF , 0xF0
, 64, 28, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0xFF , 0xFF , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x0F , 0x80 
, 0x01 , 0xF0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x3C , 0x00 , 0x00 , 0x3C , 0x00 
, 0x00 , 0x00 , 0x00 , 0x70 , 0x00 , 0x38 , 0x0E , 0x00 , 0x00 , 0x00 , 0x00 
, 0xE0 , 0x00 , 0x0E , 0x07 , 0x00 , 0x00 , 0x00 , 0x01 , 0xC0 , 0x00 , 0x03 
, 0x07 , 0x80 , 0x00 , 0x00 , 0x01 , 0xC0 , 0x00 , 0x03 , 0x03 , 0x80 , 0x00 
, 0x00 , 0x03 , 0xC0 , 0x00 , 0x00 , 0x03 , 0xC0 , 0x00 , 0x00 , 0x03 , 0x80 
, 0x00 , 0x00 , 0x01 , 0xC0 , 0x00 , 0x00 , 0x03 , 0x80 , 0x00 , 0x00 , 0x01 
, 0xC0 , 0x00 , 0x00 , 0x03 , 0x80 , 0x00 , 0x00 , 0x01 , 0xC0 , 0x00 , 0x00 
, 0x03 , 0xC0 , 0x00 , 0x00 , 0x03 , 0xC0 , 0x00 , 0x00 , 0x01 , 0xC0 , 0x00 
, 0x00 , 0x03 , 0x80 , 0x00 , 0x00 , 0x01 , 0xC0 , 0x00 , 0x00 , 0x07 , 0x80 
, 0x00 , 0x00 , 0x00 , 0xE0 , 0x00 , 0x00 , 0x07 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x78 , 0x00 , 0x00 , 0x0E , 0x00 , 0x00 , 0x00 , 0x00 , 0x3C , 0x00 , 0x00 
, 0x3C , 0x00 , 0x00 , 0x00 , 0x00 , 0x0F , 0x80 , 0x01 , 0xF0 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0xFF , 0xFF , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00
, 64, 28, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x07 
, 0xFF , 0xFF , 0xE0 , 0x00 , 0x00 , 0x00 , 0x00 , 0xFF , 0xFF , 0xFF , 0xFF 
, 0x00 , 0x00 , 0x00 , 0x07 , 0xFF , 0xFF , 0xFF , 0xFF , 0xE0 , 0x00 , 0x00 
, 0x1F , 0xFF , 0xFF , 0xFF , 0xFF , 0xF8 , 0x00 , 0x00 , 0x7F , 0xFF , 0xFF 
, 0xFE , 0x3F , 0xFE , 0x00 , 0x00 , 0xFF , 0xFF , 0xFF , 0xFF , 0xCF , 0xFF 
, 0x00 , 0x01 , 0xFF , 0xFF , 0xFF , 0xFF , 0xF3 , 0xFF , 0x80 , 0x01 , 0xFF 
, 0xFF , 0xFF , 0xFF , 0xF8 , 0xFF , 0x80 , 0x03 , 0xFF , 0xFF , 0xFF , 0xFF 
, 0xFC , 0x7F , 0xC0 , 0x03 , 0xFF , 0xFF , 0xFF , 0xFF , 0xFC , 0x3F , 0xC0 
, 0x07 , 0xFF , 0xFF , 0xFF , 0xFF , 0xFE , 0x3F , 0xE0 , 0x07 , 0xFF , 0xFF 
, 0xFF , 0xFF , 0xFE , 0x3F , 0xE0 , 0x07 , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF 
, 0x7F , 0xE0 , 0x07 , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xE0 , 0x07 
, 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xE0 , 0x07 , 0xFF , 0xFF , 0xFF 
, 0xFF , 0xFF , 0xFF , 0xE0 , 0x03 , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF 
, 0xC0 , 0x03 , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xC0 , 0x01 , 0xFF 
, 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0x80 , 0x01 , 0xFF , 0xFF , 0xFF , 0xFF 
, 0xFF , 0xFF , 0x80 , 0x00 , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0x00 
, 0x00 , 0x7F , 0xFF , 0xFF , 0xFF , 0xFF , 0xFE , 0x00 , 0x00 , 0x1F , 0xFF 
, 0xFF , 0xFF , 0xFF , 0xF8 , 0x00 , 0x00 , 0x07 , 0xFF , 0xFF , 0xFF , 0xFF 
, 0xE0 , 0x00 , 0x00 , 0x00 , 0xFF , 0xFF , 0xFF , 0xFF , 0x00 , 0x00 , 0x00 
, 0x00 , 0x07 , 0xFF , 0xFF , 0xE0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00
, 64, 28, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x0F , 0xFF , 0xFF 
, 0xFF , 0xFF , 0xFF , 0xFF , 0xF0 , 0x0F , 0x73 , 0x33 , 0x33 , 0x33 , 0x33 
, 0x33 , 0xB0 , 0x0D , 0xCC , 0xCC , 0xCC , 0xCC , 0xCC , 0xCE , 0xF0 , 0x0F 
, 0x73 , 0x33 , 0x33 , 0x33 , 0x33 , 0x33 , 0xB0 , 0x0D , 0xC8 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x0E , 0xF0 , 0x0F , 0x70 , 0x00 , 0x00 , 0x00 , 0x00 , 0x13 
, 0xB0 , 0x0D , 0xC8 , 0x00 , 0x00 , 0x00 , 0x00 , 0x0E , 0xF0 , 0x0F , 0x70 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x13 , 0xB0 , 0x0D , 0xC8 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x0E , 0xF0 , 0x0F , 0x70 , 0x00 , 0x00 , 0x00 , 0x00 , 0x13 , 0xB0 
, 0x0D , 0xC8 , 0x00 , 0x00 , 0x00 , 0x00 , 0x0E , 0xF0 , 0x0F , 0x70 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x13 , 0xB0 , 0x0D , 0xC8 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x0E , 0xF0 , 0x0F , 0x70 , 0x00 , 0x00 , 0x00 , 0x00 , 0x13 , 0xB0 , 0x0D 
, 0xC8 , 0x00 , 0x00 , 0x00 , 0x00 , 0x0E , 0xF0 , 0x0F , 0x70 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x13 , 0xB0 , 0x0D , 0xC8 , 0x00 , 0x00 , 0x00 , 0x00 , 0x0E 
, 0xF0 , 0x0F , 0x70 , 0x00 , 0x00 , 0x00 , 0x00 , 0x13 , 0xB0 , 0x0D , 0xC8 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x0E , 0xF0 , 0x0F , 0x70 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x13 , 0xB0 , 0x0D , 0xC8 , 0x00 , 0x00 , 0x00 , 0x00 , 0x0E , 0xF0 
, 0x0F , 0x70 , 0x00 , 0x00 , 0x00 , 0x00 , 0x13 , 0xB0 , 0x0D , 0xCC , 0xCC 
, 0xCC , 0xCC , 0xCC , 0xCE , 0xF0 , 0x0F , 0x73 , 0x33 , 0x33 , 0x33 , 0x33 
, 0x33 , 0xB0 , 0x0D , 0xCC , 0xCC , 0xCC , 0xCC , 0xCC , 0xCE , 0xF0 , 0x0F 
, 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xF0 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00  };


#endif

char levels[]={
       17,30,    //ball offset, box offset
       0x55,0x55,0x55,0x55,
       0x45,0x00,0x00,0x91,
       0x40,0x00,0x02,0x15,
       0x40,0x00,0x58,0x01,
       0x40,0x52,0x00,0x05,
       0x52,0x08,0x00,0x81,
       0x48,0x00,0x25,0x21,
       0x40,0x05,0x80,0x09,
       0x55,0x55,0x55,0x55,
//level2
       30,86,
       0x10,0x44,0x40,0x45,
       0x40,0x80,0x00,0x01,
       0x01,0x81,0x80,0x80,
       0x44,0x80,0x08,0x11,
       0x00,0x04,0x08,0x04,
       0x40,0x11,0x08,0x01,
       0x01,0x04,0x40,0x69,
       0x40,0x00,0x00,0x04,
       0x10,0x40,0x00,0x10,
//level3
       30,46,
       0x55,0x55,0x55,0x55,
       0x40,0x00,0x00,0x91,
       0x40,0x50,0x00,0x51,
       0x40,0x60,0x02,0x01,
       0x48,0x00,0x94,0x09,
       0x46,0x08,0x24,0x25,
       0x45,0x86,0x08,0x95,
       0x60,0x05,0x80,0x01,
       0x55,0x55,0x55,0x55,
//level4
       125,30,
       0x55,0x55,0x55,0x55,
       0x40,0x00,0x00,0x11,
       0x40,0x04,0x00,0x01,
       0x59,0x89,0x99,0x99,
       0x44,0x62,0x44,0x45,
       0x59,0x98,0x99,0x99,
       0x40,0x04,0x00,0x01,
       0x40,0x40,0x00,0x41,
       0x55,0x55,0x55,0x55,
//level5
       17,110,
       0x15,0x55,0x55,0x54,
       0x40,0x40,0x41,0x01,
       0x41,0x84,0x82,0x11,
       0x50,0x00,0x41,0x01,
       0x61,0x90,0x00,0x05,
       0x50,0x01,0x21,0x01,
       0x64,0x11,0x10,0x11,
       0x40,0x40,0x24,0x19,
       0x15,0x55,0x55,0x54,
//level6
       65,113,
       0x00,0x55,0x55,0x55,
       0x01,0x02,0x01,0x89,
       0x04,0x02,0x00,0x45,
       0x10,0x02,0x00,0x01,
       0x40,0x02,0x00,0x01,
       0x50,0x02,0x04,0x05,
       0x40,0x02,0x00,0x41,
       0x41,0x02,0x05,0x81,
       0x55,0x55,0x55,0x55,
//level7
       115,122,
       0x55,0x55,0x55,0x55,
       0x40,0x00,0x00,0x01,
       0x14,0x54,0x18,0x59,
       0x18,0x18,0x44,0x44,
       0x04,0x10,0x54,0x50,
       0x14,0x10,0x64,0x64,
       0x40,0x00,0x00,0x01,
       0x40,0x60,0x00,0x19,
       0x55,0x55,0x55,0x55,
//level8
       108,98,
       0x55,0x55,0x55,0x54,
       0x42,0x50,0x00,0x05,
       0x41,0x81,0x48,0x01,
       0x42,0x51,0x18,0x01,
       0x50,0x01,0x41,0x91,
       0x51,0x00,0x02,0x61,
       0x62,0x40,0x81,0x11,
       0x50,0x00,0x00,0x01,
       0x15,0x55,0x55,0x55,
//level9
       30,72,
       0x04,0x55,0x55,0x54,
       0x19,0x80,0x01,0x01,
       0x62,0x40,0x20,0x04,
       0x11,0x09,0x42,0x41,
       0x41,0x86,0x20,0x09,
       0x40,0x09,0x40,0x04,
       0x66,0x00,0x00,0x10,
       0x40,0x00,0x00,0x40,
       0x55,0x55,0x55,0x00,
//level10
       93,36,
       0x00,0x55,0x55,0x54,
       0x55,0x20,0x00,0x01,
       0x40,0x05,0x62,0x49,
       0x48,0x06,0x18,0x04,
       0x40,0x04,0x20,0x49,
       0x66,0x04,0x90,0x44,
       0x18,0x05,0x41,0x50,
       0x40,0x00,0x04,0x44,
       0x15,0x55,0x50,0x41,
//level11
       30,108,
       0x55,0x55,0x55,0x55,
       0x40,0x01,0x00,0x01,
       0x41,0xA0,0x02,0x85,
       0x50,0x20,0x14,0x09,
       0x60,0x06,0x68,0x15,
       0x51,0x40,0x14,0x01,
       0x60,0x92,0x00,0x09,
       0x59,0x50,0x04,0x05,
       0x14,0x55,0x55,0x54,
//level12
       17,92,
       0x50,0x01,0x41,0x54,
       0x45,0x56,0x15,0x25,
       0x40,0x28,0x00,0x81,
       0x45,0x05,0x81,0x91,
       0x44,0x85,0x61,0x41,
       0x45,0x05,0x01,0x11,
       0x40,0x08,0x00,0x01,
       0x40,0x00,0x20,0x01,
       0x55,0x55,0x55,0x55,
//level13
       18,113,
       0x15,0x55,0x55,0x54,
       0x41,0x00,0x00,0x85,
       0x44,0x06,0x02,0x51,
       0x40,0x00,0x80,0x11,
       0x48,0x00,0x00,0x19,
       0x44,0x00,0x20,0x01,
       0x50,0x00,0x88,0x19,
       0x40,0x40,0x21,0x11,
       0x15,0x55,0x55,0x54,
//level14
       36,50,
       0x55,0x55,0x55,0x55,
       0x66,0x00,0x00,0x99,
       0x49,0x00,0x01,0x41,
       0x40,0x00,0x02,0x01,
       0x40,0x00,0x24,0x01,
       0x40,0x02,0x00,0x01,
       0x49,0x00,0x00,0x41,
       0x66,0x00,0x00,0x99,
       0x55,0x55,0x55,0x55,
//level15
       51,76,
       0x15,0x54,0x55,0x54,
       0x40,0x09,0x00,0x21,
       0x44,0x84,0x10,0x21,
       0x40,0x40,0x68,0x61,
       0x11,0x01,0x20,0x11,
       0x60,0x00,0x10,0x61,
       0x10,0x00,0x80,0x04,
       0x60,0x00,0x00,0x09,
       0x15,0x55,0x55,0x54,
//level16
       35,19,
       0x55,0x55,0x55,0x55,
       0x50,0x62,0x00,0x09,
       0x60,0x98,0x00,0x05,
       0x51,0x50,0x08,0x05,
       0x50,0x02,0x64,0x01,
       0x68,0x00,0x09,0x81,
       0x52,0x00,0x55,0x81,
       0x59,0x04,0x00,0x01,
       0x55,0x55,0x55,0x55,
//level17
       29,124,
       0x55,0x55,0x55,0x55,
       0x49,0x00,0x00,0x41,
       0x44,0x26,0x98,0x11,
       0x40,0x19,0x64,0x81,
       0x49,0x00,0x02,0x41,
       0x42,0x60,0x09,0x01,
       0x44,0x11,0x64,0x11,
       0x40,0x21,0x80,0x01,
       0x55,0x55,0x55,0x55,
//level18
       115,26,
       0x55,0x55,0x55,0x55,
       0x48,0x02,0x01,0x01,
       0x41,0x98,0x06,0x01,
       0x40,0x64,0x01,0x81,
       0x40,0x81,0x02,0x61,
       0x46,0x40,0x49,0x01,
       0x49,0x84,0x84,0x01,
       0x64,0x04,0x00,0x41,
       0x55,0x55,0x55,0x55,
//level19
       126,110,
       0x55,0x55,0x55,0x55,
       0x60,0x14,0x00,0x59,
       0x44,0x10,0x00,0x61,
       0x49,0x02,0x50,0x81,
       0x44,0x01,0x80,0x01,
       0x40,0x10,0x24,0x01,
       0x45,0x24,0x58,0x11,
       0x49,0x18,0x00,0x51,
       0x55,0x55,0x55,0x55,
//level20
       77,66,
       0x55,0x55,0x55,0x55,
       0x40,0x98,0x00,0x01,
       0x58,0x24,0x58,0x05,
       0x44,0x48,0x04,0x11,
       0x40,0x41,0x41,0x09,
       0x44,0x10,0x21,0x11,
       0x50,0x25,0x18,0x25,
       0x40,0x00,0x26,0x01,
       0x55,0x55,0x55,0x55,
//level21
       103,105,
       0x55,0x55,0x55,0x55,
       0x45,0x40,0x08,0x05,
       0x40,0x40,0x00,0x45,
       0x40,0x58,0x00,0x21,
       0x42,0x00,0x80,0x85,
       0x40,0x10,0x05,0x61,
       0x42,0x20,0x02,0x29,
       0x55,0x55,0x55,0x55,
       0x00,0x00,0x00,0x00,
//level22
       103,105,
       0x55,0x55,0x55,0x55,
       0x64,0x19,0x18,0x11,
       0x40,0x10,0x00,0x01,
       0x60,0x10,0x60,0x81,
       0x51,0x80,0x02,0x15,
       0x48,0x40,0x56,0x01,
       0x40,0x04,0x40,0x81,
       0x55,0x55,0x55,0x55,
       0x00,0x00,0x00,0x00,
//level23
       103,105,
       0x15,0x55,0x55,0x54,
       0x44,0x19,0x18,0x11,
       0x40,0x20,0x40,0x01,
       0x50,0x10,0x21,0x81,
       0x41,0x81,0x0A,0x21,
       0x58,0x40,0x52,0x01,
       0x40,0x04,0x40,0x81,
       0x15,0x55,0x55,0x54,
       0x00,0x00,0x00,0x00,
//level24
       103,105,
       0x55,0x55,0x55,0x55,
       0x40,0x04,0x00,0x05,
       0x45,0x88,0x01,0x65,
       0x46,0x00,0x24,0x15,
       0x42,0x09,0x14,0x01,
       0x46,0x21,0x00,0x51,
       0x45,0x00,0x45,0x69,
       0x55,0x55,0x55,0x55,
       0x00,0x00,0x00,0x00,
//level25
       103,105,
       0x55,0x55,0x55,0x55,
       0x40,0x00,0x00,0x11,
       0x48,0x58,0x08,0x01,
       0x40,0x60,0x81,0x41,
       0x48,0x01,0x41,0x81,
       0x46,0x02,0x40,0x21,
       0x45,0x84,0x00,0x01,
       0x55,0x55,0x55,0x55,
       0x00,0x00,0x00,0x00
};
